<?php

	include_once 'modelo/requisitoVaga.modelo.php';
 
class ControladorRequisitoVaga
{
 
static public function ctrAddRequisitoVaga()
{
 
if(isset($_POST["cadastrar"])) 
{
	if (!empty($_POST["tipoRequisito"]) && !empty($_POST["requisito"])) 
	{ 
				$requisito = addslashes($_POST["requisito"]);
				$tipoRequisito = addslashes($_POST["tipoRequisito"]);
				$carater = addslashes($_POST["carater"]);
				$idVaga = addslashes($_POST["idVaga"]);
				$dataCadastro = addslashes(date("d-m-Y H:i:s"));
				$idUsuario = addslashes($_SESSION['ID_usuario']);

				$dados = array("tipoRequisito" => filter_var($tipoRequisito,FILTER_SANITIZE_STRIPPED),
				"requisito" => filter_var($requisito,FILTER_SANITIZE_STRIPPED), 
				"dataCadastro" => filter_var($dataCadastro,FILTER_SANITIZE_STRIPPED),
				"carater" => filter_var($carater,FILTER_SANITIZE_STRIPPED),
				"idVaga" => filter_var($idVaga,FILTER_SANITIZE_STRIPPED),
				"idUsuario" => filter_var($idUsuario,FILTER_SANITIZE_STRIPPED));

				$verifExistencia = ControladorRequisitoVaga::ctrVerificarSeEquipamentoJaExistePorCodigo($requisito,$idVaga);
				if ($verifExistencia == true) 
				{ 
					$Vaga = ModeloRequisitoVaga::mdlAddRequisitoVaga($dados);

					if($Vaga == "ok"){
							echo"
					<script>
					Swal.fire({
						position: 'top-end',
						icon: 'success',
						title: 'Requisito Cadastrado com sucesso!',
						showConfirmButton: false,
						timer: 5000
					})
					</script>
					";	
					}else{
						echo"
						<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Erro: Não foi possivel cadastrar o Requisito',
								showConfirmButton: false,
								timer: 5000
							})
						</script>";
						
					}
				}else
				{
					echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Não foi possivel cadastrar Porque este Requisito já existe para esta Vaga',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
					";
				}

	}
			else{
				echo"
					<script>
							Swal.fire({
								position: 'top-end',
								icon: 'error',
								title: 'Erro: Preencha os campos obrigatorios',
								showConfirmButton: false,
								timer: 5000
							})
					</script>
				";	
			}	
}

}


static public function ctrVerificarSeEquipamentoJaExistePorCodigo($requisito,$idVaga){

	$Vaga = ModeloRequisitoVaga::mdlMostrarTodosRequisitoVagaPorRequisitoOuidVaga($requisito,$idVaga);
	if (empty($Vaga)) {
		return true;
	}
	else {
		return false;
	}
}
 
 
static public function ctrMostrarTodasVagas(){

	$Vaga = ModeloVaga::mdlMostrarTodasVagas();
	return $Vaga;
	
}



static public function ctrMostrarTodosRequisitosPoridVaga($idVaga){
	$Vaga = ModeloRequisitoVaga::mdlMostrarTodosRequisitosPoridVaga($idVaga);
	return $Vaga;
}

static public function ctrMostrarTodosRequisitosDaVagaPoridVagaETipoRequisito($idVaga,$tipoRequisito){
	$Vaga = ModeloRequisitoVaga::mdlMostrarTodosRequisitosDaVagaPoridVagaETipoRequisito($idVaga,$tipoRequisito);
	return $Vaga;
}


static public function ctrMostrarDadosDoUsuarioPorID($id){

		$Vaga = ModeloUsuario::mdlMostrarDadosDoUsuarioPorID(addslashes($id));

		return $Vaga;

	}

	static public function ctrActualizarDadosUsuario($nome, $bi_nif,$sexo, $email,$id,$senha){

		$Vaga = ModeloUsuario::mdlActualizarDadosUsuario(addslashes($nome), addslashes($bi_nif), addslashes($sexo), addslashes($email),addslashes($id),md5(addslashes($senha)));

		return $Vaga;

	}
 
	static public function ctrActualizarDadosUsuarioprofessors($nome, $bi_nif, $nivelDeAcesso, $id){  

		$Vaga = ModeloUsuario::mdlActualizarDadosUsuarioprofessors(addslashes($nome), addslashes($bi_nif), addslashes($nivelDeAcesso),addslashes($id));

		return $Vaga;

	}

	static public function ctrActualizarImagemPerfilUsuario($imagem,$id){

		$Vaga = ModeloUsuario::mdlActualizarImagemPerfilUsuario($imagem,addslashes($id));

		return $Vaga;

	}

	static public function ctrActualizarCodigoParaReporSenha($idUsuario, $codigo){

		$Vaga = ModeloUsuario::mdlActualizarCodigoParaReporSenha($idUsuario, $codigo);
		return $Vaga;

	}
 
	static public function ctrActualizarSenhaUsuario($senhaAntiga,$id, $senha){

		$Vaga = ModeloUsuario::mdlActualizarSenhaUsuario(addslashes($senhaAntiga),addslashes($id), md5(addslashes($senha)));
		return $Vaga;

	}

	static public function ctrActualizarReporSenhaUsuario($senha,$id,$codigoParaReporSenha){

		$Vaga = ModeloUsuario::mdlActualizarReporSenhaUsuario(md5(addslashes($senha)),$id,$codigoParaReporSenha);
		return $Vaga;

	}

	static public function ctrDeletarUsuario($id){

		$Vaga = ModeloUsuario::mdlDeletarUsuario(addslashes($id));
		return $Vaga;

	}

}

?>